//
//  B5UserAccountBillingOverview.h
//  ApplicationFrameworks
//
//  Created by Michael Fey on 4/22/16.
//
//

#import <Foundation/Foundation.h>
#import <OnePasswordDataModel/OnePasswordDataModel.h>

/*
 All billing status descriptions taken from https://github.com/AgileBits/B5Book/blob/master/server/billing/overview.md as of 2016-04-22. That document should be considered truth and referenced for the most up to date information.

 [Roo]
 */

// A credit card has not been added and the trial is still active.
FOUNDATION_EXPORT NSString * const B5UserAccountBillingStatusTrial;

// A credit card has been added and all is well with the world.
FOUNDATION_EXPORT NSString * const B5UserAccountBillingStatusActive;

// Payment failed. There will be three more attempts over the next week, and then the subscription will be canceled.
FOUNDATION_EXPORT NSString * const B5UserAccountBillingStatusLapsed;

// Subscription set to cancel at the period end. Account is still active until the end of the billing period.
FOUNDATION_EXPORT NSString * const B5UserAccountBillingStatusCancelAtPeriodEnd;

// Subscription has been canceled or trial has expired.
FOUNDATION_EXPORT NSString * const B5UserAccountBillingStatusFrozen;

@interface B5UserAccountBillingOverview : B5DatabaseObject

+ (NSString *)localizedDescriptionForBillingStatus:(NSString *)billingStatus;

- (instancetype)initWithID:(OPID)billingID status:(NSString *)status accountWillFreezeAt:(NSDate *)accountWillFreezeAt storageCapacityInMegabytes:(NSUInteger)storageCapacityInMegabytes storageUsedInMegabytes:(NSUInteger)storageUsedInMegabytes;

@property (nonatomic, readonly) NSString *status;
@property (nonatomic, readonly) NSDate *accountWillFreezeAt;
@property (nonatomic, readonly) NSUInteger storageCapacityInMegabytes;
@property (nonatomic, readonly) NSUInteger storageUsedInMegabytes;

@end
